import ctypes
import sdl2
import sdl2.ext
import sdl2.sdlttf

RESOURCES = sdl2.ext.Resources(__file__, ".")

sdl2.ext.init()
sdl2.sdlttf.TTF_Init()

window = sdl2.ext.Window("Hello World", size=(640, 480))
window.show()

factory = sdl2.ext.SpriteFactory(sdl2.ext.SOFTWARE)
sprite = factory.from_image(RESOURCES.get_path("hello.png"))

spriterenderer = factory.create_sprite_render_system(window)
spriterenderer.render(sprite)

# 2nd arg is ptsize
size =  18
fonts = [
    sdl2.sdlttf.TTF_OpenFont("OxygenMono-Regular.ttf", size),
    sdl2.sdlttf.TTF_OpenFont("UbuntuMono-R.ttf", size),
    sdl2.sdlttf.TTF_OpenFont("FreeMono.ttf", size),
    sdl2.sdlttf.TTF_OpenFont("Hack-Regular.ttf", size),
    sdl2.sdlttf.TTF_OpenFont("OpenDyslexicMono-Regular.otf", size)
    ]


s = "Hello World"

white = sdl2.SDL_Color(255, 255, 255, 255)
black = sdl2.SDL_Color(0, 0, 0, 255)

w = ctypes.c_int()
h = ctypes.c_int()

windowsurface = sdl2.SDL_GetWindowSurface(window.window)

y = 200

for font in fonts:
    sdl2.sdlttf.TTF_SizeText(font, s, ctypes.byref(w), ctypes.byref(h))
    print(w, h)
    print(sdl2.sdlttf.TTF_FontHeight(font))
    #sdl2.sdlttf.TTF_SizeUTF8
    #sdl2.sdlttf.TTF_SizeUnicode

    #black = sdl2.ext.Color(0,0,0)
    #white = sdl2.ext.Color(1,1,1)
    # I got errors when trying to pass the above in RenderText

    sdl2.sdlttf.TTF_SetFontHinting(font, sdl2.sdlttf.TTF_HINTING_MONO)
    # NORMAL, LIGHT, MONO, NONE

    # also Solid and Blended versions available
    surface = sdl2.sdlttf.TTF_RenderText_Shaded(font, s, black, white)

    sdl2.SDL_BlitSurface(surface, None, windowsurface, sdl2.SDL_Rect(0, y, w, h))
    y += h.value

sdl2.SDL_UpdateWindowSurface(window.window)


processor = sdl2.ext.TestEventProcessor()
processor.run(window)


sdl2.SDL_FreeSurface(surface)

sdl2.sdlttf.TTF_CloseFont(font)
sdl2.sdlttf.TTF_Quit()
sdl2.ext.quit()
