# fix that delay on ESCAPE
import os
os.environ['ESCDELAY'] = "25"


import curses
import curses.wrapper as wrap

import sys


""" A Terminal UI has a couple of facets that appeal to me:
  1. I can write it in python (as opposed to a web UI)
  2. It runs everywhere! (even in a browser, hehe)
  3. Keyboard based interfaces are fast to use. (slow to learn though)
  
  Also I can still write it to pull data from an http based server.
  Downsides:
  1. It gets ugly fast as data onscreen increases.
  2. It won't work great on tablets/phones.

"""  




class Buffer:

  bufsize = (65536, 256)
  def __init__(self):
    self.pad = curses.newpad(*self.bufsize)
    # viewport top,left
    self.row = 0
    self.col = 0
    self.styles = {}
    # cursor position
    self.x = 0
    self.y = 0
  
  def insert(self, c):
    # inserts c at the current cursor position
    self.pad.addch(self.y, self.x, c)
    if c == 13 and self.y < self.bufsize[0]-1:
      self.y += 1
      self.x = 0
    elif self.x < self.bufsize[1]-1:
      self.x += 1

  


class AppState:
  INSERT = 0
  COMMAND = 1
  GUIDED = 2
  VISUAL = 3

  def __init__(self, parent):
    self.key_stack = []
    self.cmd = []
    self.mode = 0
    self.buffers = []
    self.currentbuf = 0
    self.buffers.append(Buffer())
    self.done = False
    self.winsize = parent.getmaxyx()
    self.parent = parent

  def curbuf(self):
    return self.buffers[self.currentbuf]

  def refresh_buf(self):
    b = self.curbuf()
    b.pad.refresh(b.row, b.col, 1, 0, self.winsize[0]-2, self.winsize[1]-1)

  def status_line(self, s):
    self.parent.addstr(self.winsize[0]-1,0, s)
    self.parent.refresh()


def input_mode(state):
  c = state.key_stack.pop()
  p = state.curbuf()
  if c == 27:
    state.mode = state.COMMAND
    state.status_line("-- COMMAND --")
  else:  
    p.insert(c)  

  state.refresh_buf()


def command_mode(state, guided=False):
  c = state.key_stack.pop()
  if c == 27:
    state.cmd = []
    if state.mode == state.COMMAND:
      state.mode = state.GUIDED
    else:
      state.mode = state.COMMAND
    draw_menu(state)

  # short form commands  
  elif c == ord("q"):
    state.done = True

  # long version commands

  else:
    state.cmd.append(c)

  stat_line = "-- COMMAND --:" + "".join([chr(f) for f in state.cmd])  
  state.parent.addstr(state.winsize[0]-1, 0, stat_line)
  state.parent.refresh()

def draw_menu(state):
  state.parent.addstr(0, 0, "File Edit View Debug Help", curses.A_REVERSE)


def visual_mode(state):
  pass


def main(stdscr):
  # give me full control of the keyboard
  stdscr.keypad(0)
  stdscr.notimeout(0)
  curses.noecho()
  curses.nonl()

  try:
    # setup the right colors
    curses.use_default_colors()
  
    for f in range(1, 256):
      curses.init_pair(f, f, curses.COLOR_BLACK)
  except:
    print("This application requires 256 color support")
    sys.exit(1)
  
  state = AppState(stdscr)

  # startup screen
  p = state.curbuf().pad
  p.addstr(3, 5, "Welcome to Scale - the text based python IDE.")
  p.addstr(4, 5, "Press the escape key once to enter command mode")
  p.addstr(5, 5, "Again to enter guided command mode (menu mode)")

  state.refresh_buf()


  p.getch()

  p.erase()
  state.refresh_buf()

  # main loop
  while(not state.done):
    c = p.getch()
    state.key_stack.append(c)
    if state.mode == state.INSERT:
      input_mode(state)
    elif state.mode == state.COMMAND:
      command_mode(state, False)
    elif state.mode == state.GUIDED:
      command_mode(state, True)
    elif state.mode == state.VISUAL:
      visual_mode(state)





if __name__ == "__main__":
  wrap(main)

  # should return the terminal to a usable state
  # if not type "reset" at the command line

