# fix that delay on ESCAPE
import os
os.environ['ESCDELAY'] = "25"


import curses
import curses.wrapper as wrap

import sys


""" A Terminal UI has a couple of facets that appeal to me:
  1. I can write it in python (as opposed to a web UI)
  2. It runs everywhere! (even in a browser, hehe)
  3. Keyboard based interfaces are fast to use. (slow to learn though)
  
  Also I can still write it to pull data from an http based server.
  Downsides:
  1. It gets ugly fast as data onscreen increases.
  2. It won't work great on tablets/phones.

"""  

""" modes
  0 = input
  1 = menu
  2 = command (silent menu)
"""

mode = 0



def main(stdscr):

  stdscr.keypad(0)
  stdscr.notimeout(0)

  try:
    # setup the right colors
    curses.use_default_colors()
  
    for f in range(1, 256):
      curses.init_pair(f, f, curses.COLOR_BLACK)
  except:
    print("This application requires 256 color support")
    sys.exit(1)
  
  while(1):
    c = stdscr.getch()
    
    stdscr.addch(10, 10, c)




if __name__ == "__main__":
  wrap(main)

  # if not type "reset" at the command line

