import curses
import curses.wrapper as wrap


""" A Terminal UI has a couple of facets that appeal to me:
  1. I can write it in python (as opposed to a web UI)
  2. It runs everywhere! (even in a browser, hehe)
  3. Keyboard based interfaces are fast to use. (slow to learn though)
  
  Also I can still write it to pull data from an http based server.
  Downsides:
  1. It gets ugly fast as data onscreen increases.
  2. It won't work great on tablets/phones.

"""  

def get_current_palette():
  colors = []
  for f in range(1, 256):
    colors.append(curses.color_content(f))

  pairs = []
  for f in range(1, 256):
    pairs.append(curses.pair_content(f))

  return colors, pairs

def restore_palette(colors, pairs):
  f = 1
  for r,g,b in colors:
    curses.init_color(f, r,g,b)
    f += 1

  f = 1
  for fg, bg in pairs:
    curses.init_pair(f, fg ,bg)


def make_palette():
  palette = []
  # 6x6x6 color cube I guess?
  palette_basics = [0, 0x5f/0xff, 0x87/0xff, 0xaf/0xff, 0xd7/0xff, 1]
  for fr in palette_basics:
    for fg in palette_basics:
      for fb in palette_basics:
        palette.append((int(fr*1000), int(fg*1000), int(fb*1000)))

  # grays
  for fg in range(24):
    scaled = int(round(fg/24*1000))
    palette.append((scaled, scaled, scaled))
  return palette


def set_colors(palette):
  # sets the curses high colors
  f = 16 # don't mess with the default 16
  for r,g,b in palette:  
    try:
      curses.init_color(f, r,g,b)
    except:
      raise Exception(str((f, r,g,b)))
    f += 1

  for f in range(1, 256):
    curses.init_pair(f, f, curses.COLOR_BLACK)
   

def main(stdscr):
  stdscr.addstr(0,0, "Hello World", curses.A_REVERSE)

  #set_colors(make_palette())
  # have some issues with the above

  # fortunately the below seems to give me a similar color cube 
  curses.use_default_colors()
  
  for f in range(1, 256):
    curses.init_pair(f, f, curses.COLOR_BLACK)
  
  for f in range(1, 256):
    stdscr.addstr(int(f/16)+2, int(f%16), "O", curses.color_pair(f))

  if curses.has_colors():
    stdscr.addstr(20, 0, "This terminal has colors!")
  else:
    stdscr.addstr(20, 0, "This terminal has no colors. :-(")


  stdscr.addstr(21, 0, curses.termname())  

  stdscr.refresh()

  stdscr.getch()




if __name__ == "__main__":
  wrap(main)

  # this seems to restore the terminal colors
  curses.use_default_colors()
  # if not type "reset" at the command line

