#ifndef TOOLREG_HPP
#define TOOLREG_HPP

#include <optional>
#include "tool.hpp"
#include "textedit.hpp"
#include "textbuffer.hpp"
#include "fman.hpp"
#include "search.hpp"

class ToolReg {
    private:
        // Members
        int nextKey;
        std::map<int, Tool*> tools;
        std::map<int, TextEdit*> editors;
    public:
        ToolReg();
        // API
        void add(TextEdit* ed);
        void add(FMan* fman);
        void add(Search* s);
        void add(TextBuffer* buffer);
        bool remove(TextEdit* ed);
        bool remove(Tool* tool);
        Tool* tool(TextEdit* ed);
        Tool* tool(FMan* ed);
        Tool* toolInFocus();
        TextEdit* editorInFocus();
        std::optional<TextEdit*> isThereABlankEditor();
        std::optional<TextEdit*> isThereAnEditorWithFilename(QString);

};

#endif
