#ifndef TOOL_HPP
#define TOOL_HPP

#include <optional>
#include <QtWidgets>


enum struct ToolType {
    FMan,
    TextEdit,
    TextBuffer,
    Search,
};

class Tool : public QWidget {
    Q_OBJECT

    public:
        ToolType type;
        QString label;
        Tool();
        void spawn(QMainWindow*);
        void show();
        void hide();
        void moveToShelf();
        void moveToCenter();
        bool isDocked();
        void setKey(int k) { _key=k; };
        int getKey() { return _key; };
        virtual QString currentFilename() { return ""; };
        virtual QString saveFile() { return ""; };
        virtual bool isUnsaved() { return false; };
        virtual void closeFile() {};
        void setArea(Qt::DockWidgetArea a) { area = a; };

    private:
        Qt::DockWidgetArea area;
        int _key;
        bool docked;
        QDockWidget* dock;
};

#endif
