#include "tool.hpp"


Tool::Tool() : QWidget() {
    label = "";
    area = Qt::RightDockWidgetArea;
}

void Tool::spawn(QMainWindow* main) {
    dock = new QDockWidget(label, main);
    dock->setWidget(this);
    main->addDockWidget(area, dock);
    docked = true;
    hide();
}

void Tool::moveToShelf() {
    docked = true;
    // adding the widget to the main layout removes it from the dock
    dock->setWidget(this);
    show();
}

void Tool::moveToCenter() {
    docked = false;
    dock->hide();
    show();
}

bool Tool::isDocked() {
    return docked;
}

void Tool::show() {
    if (docked) {
        dock->show();
        dock->raise();
    } else {
        QWidget::show();
        QWidget::raise();
    }
    setFocus();
}

void Tool::hide() {
    if (docked) {
        dock->hide();
    } else {
        // do nothing?
    }
}
