#ifndef TEXTEDIT_HPP
#define TEXTEDIT_HPP

#include <QtWidgets>
#include <QtCore>
#include "logger.hpp"
#include "tool.hpp"
#include "syntax.hpp"


class Editor : public QTextEdit {
    Q_OBJECT

    public:
        Editor();
        void keyPressEvent(QKeyEvent*);
};


class TextEdit : public Tool {
    Q_OBJECT

    public:
        TextEdit();
        // Reimplemented from Tool
        void spawn(QMainWindow*);
        QString currentFilename();
        QString saveFile();

        // API
        bool isEmpty();
        bool isUnsaved();
        bool hasFilename();
        void openFile(const QString);
        void closeFile();

    public slots:
        void findNext(QString);
        void findFirst(QString);
        void findNextWithCase(QString);
        void findFirstWithCase(QString);

    private:
        QMainWindow* parent;
        QString filename;
        Editor* ed;
        Highlighter* hl;
        QString filenameToLang(QString);
};

#endif
