#ifndef SYNTAX_HPP
#define SYNTAX_HPP

#include <QtCore>
#include <QtGui>
#include <tree_sitter/api.h>
#include "logger.hpp"
#include "resource.hpp"


// Declare the `tree_sitter_json` function, which is
// implemented by the `tree-sitter-json` library.
extern "C" TSLanguage* tree_sitter_c();
extern "C" TSLanguage* tree_sitter_cpp();
extern "C" TSLanguage* tree_sitter_javascript();
extern "C" TSLanguage* tree_sitter_json();
extern "C" TSLanguage* tree_sitter_lua();
extern "C" TSLanguage* tree_sitter_python();


class UserData : public QTextBlockUserData {
    public:
        UserData(): QTextBlockUserData() {};
        UserData(uint32_t d): QTextBlockUserData() { length=d; };
        uint32_t length;
};

class Parser {
    public:
        Parser();
        ~Parser();
        void setLang(TSLanguage*);
        void setSource(QString);
        void update(QString);
        TSParser *parser;
        TSTree *tree;
        TSQueryCursor* cursor;
        TSLanguage* lang;
};

class Highlighter : public QSyntaxHighlighter {
    public:
        Highlighter(QTextDocument*, QString);
        void highlightBlock(const QString &text);
        void setLanguage(const QString);

    private:
        Parser parser;
        QString curLang;
        // TODO: global?
        // capture name: format
        QMap<QString, QTextCharFormat> styles;
        // lang: highlight query
        TSQuery* hlQuery;
};

#endif
