#include "search.hpp"


/*
 * See ed3/source/search.py
 * May need to subclass QLineEdit or o/w connect QLineEdit::focusOutEvent to
 * QDockWidget::focusOutEvent
 * but setFocusProxy ought to do that?
 */ 

Search::Search() : Tool() {
    type = ToolType::Search;
    Tool::setArea(Qt::BottomDockWidgetArea);
    label = "find";
    lo = new QHBoxLayout(this);
    findEdit = new QLineEdit();
    connect(findEdit, &QLineEdit::returnPressed, this, &Search::nextResult);
    connect(findEdit, &QLineEdit::textChanged, this, &Search::needleChanged);
    caseOpt = new QCheckBox("Case &insensitive");
    lo->addWidget(findEdit);
    lo->addWidget(caseOpt);
    setFocusProxy(findEdit);
}

void Search::nextResult() {
    DEBUG("Search: return pressed");
    QString needle = findEdit->text();
    if (caseOpt->isChecked()) {
        emit searchWithCase(needle);
    } else {
        emit search(needle);
    }
}

void Search::needleChanged() {
    DEBUG("Needle changed");
    QString needle = findEdit->text();
    if (caseOpt->isChecked()) {
        emit searchWithCaseChanged(needle);
    } else {
        emit searchChanged(needle);
    }
}
