#include "resource.hpp"


QString findConfigFile(const QString filename) {
    // searches config folders for the filename and returns the absolute path
    // if not found returns ""
    // TODO: Add Win platform support
    // TODO: real config folders
    if (QDir("./data").exists(filename)) {
        return QDir("./data").absoluteFilePath(filename);
    } else {
        ERROR("Could not load file: " << filename.toStdString());
    }
    return "";
}

QString loadResource(const QString filename) {
    // loads a file from the appropriate config folder
    QString absPath = findConfigFile(filename);
    if (!absPath.isEmpty()) {
        QFile file(absPath);
        if (file.open(QFile::ReadOnly | QFile::Text))
            // converts from QByteArray to QString
            return file.readAll();
    }
    return "";
}

