#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <vector>
#include <QtWidgets>
#include "logger.hpp"
#include "cmd.hpp"
#include "tool.hpp"
#include "toolreg.hpp"
#include "fman.hpp"
#include "textedit.hpp"
#include "textbuffer.hpp"
#include "search.hpp"
#include "resource.hpp"


class MainWindow : public QMainWindow {
    Q_OBJECT
    
    public:
        MainWindow(QApplication*);

    public slots:
        // Action handlers
        void about();
        void newFile();
        void openFile();
        void saveFile();
        void closeFile();
        void discardFile();
        void quit();
        void prevTool();
        void nextTool();
        void focusShelve();
        void focus();
        void showFMan();
        void showSearch();
        void handleCommand(QString);
        void handleCommandFinished(CommandRunner*);

    private:
        // Members
        ToolReg toolReg;
        QApplication* app;
        std::map<std::string, QMenu*> menus;
        QMap<QString, Command> commands;
        QList<CommandRunner*> subprocesses;

        // Setups
        void setupStyle();
        TextEdit* setupEditor();
        TextBuffer* setupBuffer();
        void setupMenuBar();
        void setupCommands(QMenu*);
        void setupStatusBar();
        void setupFManDock();
        void setupSearchDock();

        // Helpers
        bool openInBlank(QString);
        bool showIfOpen(QString);

        QStackedWidget* main;
        QString filename;
        QStatusBar* stts;
        QMenuBar* menu;
        FMan* fman;
        Search* search;
};

#endif
