#ifndef LOGGING_HPP
#define LOGGING_HPP

#include <iostream>
#include <cstdlib>

// comment out a LEVEL to stop logging it
#define ERROR_LEVEL
#define WARN_LEVEL
#define INFO_LEVEL
#define DEBUG_LEVEL


#ifndef ERROR_LEVEL
#define ERROR(exp)
#else
#define ERROR(exp) std::cout << "ERROR: " << exp << "\n"; std::exit(1)
#endif

#ifndef WARN_LEVEL
#define WARN(exp)
#else
#define WARN(exp) std::cout << "WARN: " << exp << "\n"
#endif

#ifndef INFO_LEVEL
#define INFO(exp)
#else
#define INFO(exp) std::cout << "INFO: " << exp << "\n"
#endif

#ifndef DEBUG_LEVEL
#define DEBUG(exp)
#else
#define DEBUG(exp) std::cout << "DEBUG: " << exp << "\n"
#endif


#endif
