#ifndef FMAN_H
#define FMAN_H

/*
 * A File selector tool
 */
#include <QtWidgets>
#include <QtCore>
#include "tool.hpp"
#include "logger.hpp"


class FManList : public QListView {
    Q_OBJECT
    private:
        QString filterText;
        QFileSystemModel* fsModel;
        QSortFilterProxyModel* fsProxy;

    protected:
        virtual void keyPressEvent(QKeyEvent*);

    public:
        FManList(QWidget *);
        QList<QString> getSelected();

    signals:
        void filterChanged(QString);
        void cancel();
        void selectionMade(QList<QString>);

    public slots:
        void updateFilter();
        void checkSelection(QString);
};


class FMan : public Tool {
    Q_OBJECT


    public:
        FMan();
        // destructor?
        QString currentFilename();
        QString saveFile() { return ""; };

    signals:
        void cancel();
        void selectionMade(QList<QString>);

    public slots:
        void handleCancel();
        void handleSelection(QList<QString>);
        
    private:
        FManList* pickList;
        QLabel* helpLabel;

        void reset();

};


#endif
