#ifndef CMD_HPP
#define CMD_HPP

#include <QtCore>


enum struct OutputDestination {
    Buffer,
    Null,
};


class Command {
    public:
        // QMap requires T to have a default constructor I guess
        Command(): key(""), cli(QStringList()), category(""), label(""),
            standardOut(OutputDestination::Buffer), 
            standardError(OutputDestination::Buffer) {}
        Command(QString k, QStringList c, QString cat, QString lbl, 
                OutputDestination out, OutputDestination err): 
            key(k), cli(c), category(cat), label(lbl),
            standardOut(out), standardError(err) {}
        QString key;
        QStringList cli;
        QString category;
        QString label;
        OutputDestination standardOut;
        OutputDestination standardError;
};


const int BUFFER_TIME = 100; // milliseconds

class CommandRunner : public QObject {
    Q_OBJECT

    public:
        CommandRunner();
        void start(QStringList);
        void stopThread();

    signals:
        void resultsReady(QString);
        void finished();

    public slots:
        void readBuffers();
        void handleError(QProcess::ProcessError);
        void processFinished(int, QProcess::ExitStatus);

    private:
        QTimer* timer;
        QProcess* process;
        QString read();
        void closeOut();


};

#endif
