from PySide2.QtWidgets import QLabel
from oasis.wm.gui import WmMainWidget


def test_add_one(qtbot):
    wm = WmMainWidget()
    w1 = QLabel("hello")
    qtbot.addWidget(wm)
    wm.addWidget(w1)
    assert(w1.text() == "hello")


def test_add_two(qtbot):
    wm = WmMainWidget()
    w1 = QLabel("hello")
    w2 = QLabel("bye")
    qtbot.addWidget(wm)
    wm.addWidget(w1)
    wm.addWidget(w2)
    assert(w1.text() == "hello")
    assert(wm.selectedWidget().text() == "bye")


def test_change_split(qtbot):
    wm = WmMainWidget()
    w1 = QLabel("hello")
    w2 = QLabel("what?")
    w3 = QLabel("bye")
    qtbot.addWidget(wm)
    wm.changeSplitV()
    wm.addWidget(w1)
    wm.addWidget(w2)
    wm.changeSplitH()
    wm.addWidget(w3)
    assert(w1.text() == "hello")
    assert(wm.selectedWidget().text() == "bye")


def test_remove_one(qtbot):
    wm = WmMainWidget()
    w1 = QLabel("hello")
    w2 = QLabel("what?")
    w3 = QLabel("bye")
    qtbot.addWidget(wm)
    wm.changeSplitV()
    wm.addWidget(w1)
    wm.addWidget(w2)
    assert(wm.selectedWidget().text() == "what?")
    wm.changeSelectedLeft()
    assert(wm.selectedWidget().text() == "what?")
    wm.changeSelectedRight()
    assert(wm.selectedWidget().text() == "what?")
    wm.changeSelectedUp()
    assert(wm.selectedWidget().text() == "hello")
    wm.changeSelectedDown()
    assert(wm.selectedWidget().text() == "what?")
    wm.changeSplitH()
    wm.addWidget(w3)
    wm.changeSelectedLeft()
    assert(wm.selectedWidget().text() == "what?")
    wm.removeSelected()
    assert(wm.selectedWidget().text() == "bye")


def test_move_one(qtbot):
    wm = WmMainWidget()
    w1 = QLabel("hello")
    w2 = QLabel("what?")
    w3 = QLabel("bye")
    qtbot.addWidget(wm)
    wm.changeSplitV()
    wm.addWidget(w1)
    wm.addWidget(w2)
    wm.changeSplitH()
    wm.addWidget(w3)
    assert(wm.selectedWidget().text() == "bye")
    wm.moveSelectedUp()
    wm.changeSelectedDown()
    assert(wm.selectedWidget().text() == "hello")

