from oasis.wm.tree import Node, Tree

def test_node():
    node = Node(Node.H)
    node.insert(0, 1)
    node.insert(1, 2)
    node.insert(2, 3)
    assert(node.index == 2)
    assert(node.children[2] == 3)
    assert(len(node) == 3)

    node.remove(2)
    assert(node.index == 1)
    node.remove(0)
    assert(node.index == 0)
    assert(node.children[0] == 2)


def test_tree_selectleft():
    tree = Tree()
    for x in range(10):
        tree.insert(x)
    tree.change_selected(Tree.DIR_LEFT)
    assert(tree.cur_node.index == 8)
    tree.insert(12, Node.V)
    tree.change_selected(Tree.DIR_LEFT)
    tree.print_json()
    assert(tree.cur_node.index == 7)

    tree = Tree()
    tree.insert(0, Node.V)
    tree.insert(1, Node.V)
    tree.change_selected(Tree.DIR_LEFT)
    assert(tree.cur_node.index == 1)



def test_tree_selectright():
    tree = Tree()
    for x in range(10):
        tree.insert(x)
    tree.change_selected(Tree.DIR_LEFT)
    tree.change_selected(Tree.DIR_LEFT)
    tree.change_selected(Tree.DIR_LEFT)
    tree.change_selected(Tree.DIR_RIGHT)
    assert(tree.cur_node.index == 7)

    tree = Tree()
    tree.insert(0, Node.V)
    tree.insert(1, Node.V)
    tree.change_selected(Tree.DIR_RIGHT)
    assert(tree.cur_node.index == 1)


def test_tree_select():
    tree = Tree()
    for x in range(10):
        tree.insert(x)

    assert(tree.cur_node.cur_child() == 9)
    assert(tree.cur_node.kind == Node.H)

    tree.change_selected(Tree.DIR_RIGHT)
    assert(tree.cur_node.cur_child() == 9)
    tree.change_selected(Tree.DIR_UP)
    assert(tree.cur_node.cur_child() == 9)
    tree.change_selected(Tree.DIR_DOWN)
    assert(tree.cur_node.cur_child() == 9)

    tree.change_selected(Tree.DIR_LEFT)
    assert(tree.cur_node.cur_child() == 8)

    tree.insert(10)
    tree.change_selected(Tree.DIR_RIGHT)

def test_tree_insert():
    tree = Tree()
    tree.insert("1", Node.H)
    tree.insert("2", Node.H)
    tree.insert("3", Node.V)
    tree.insert("4", Node.V)
    tree.change_selected(tree.DIR_LEFT)
    tree.change_selected(tree.DIR_LEFT)
    tree.insert("5")
    tree.insert("6", Node.V)
    """
    H:
    -1
    -V:
    --5
    --6
    -V:
    --2
    --3
    --4
    """
    assert(tree.root.children[0] == '1')
    assert(tree.root.children[1].children[0] == '5')
    assert(tree.root.children[1].children[1] == '6')
    assert(tree.root.children[2].children[0] == '2')
    assert(tree.root.children[2].children[1] == '3')
    assert(tree.root.children[2].children[2] == '4')

    tree.change_selected(tree.DIR_UP)
    tree.remove()
    assert(tree.cur_node.index == 0)
    assert(tree.root.children[1].children == ['6'])

def test_select_again():
    tree = Tree()
    tree.insert("1", Node.H)
    tree.insert("2", Node.H)
    tree.change_selected(Tree.DIR_LEFT)
    tree.insert("3", Node.V)
    tree.change_selected(Tree.DIR_RIGHT)
    assert(tree.selected().cur_child() == "2")
    tree.change_selected(Tree.DIR_LEFT)
    assert(tree.selected().cur_child() == "3")

def test_move():
    tree = Tree()
    for x in range(10):
        tree.insert(x)

    tree.move_selected(Tree.DIR_LEFT)
    assert(tree.root.children[9] == 8)
    tree.move_selected(Tree.DIR_RIGHT)
    assert(tree.root.children[9] == 9)
