import pytest

from oasis.fileops import touch

def test_create(tmp_path):
    f = tmp_path / "a"
    assert(not f.exists())
    assert(not touch.go(("touch", str(f))))
    assert(f.exists())


def test_create_exists(tmp_path):
    f = tmp_path / "a"
    f.touch()
    assert(f.exists())
    assert(not touch.go(("touch", str(f))))
    assert(f.exists())


def test_create_invalid_path(tmp_path):
    f = tmp_path / "a" / "b"
    assert(not f.exists())
    assert(touch.go(("touch", str(f))))
    assert(not f.exists())
