from oasis.core.keyevent import string_to_key, KeyEvent, KeyBuffer, keybuffer_from_strings
from oasis.core.keyconst import KeyConst, Mods

def test_keyevent():
    key = KeyConst["a"]
    assert(KeyEvent(key) == KeyEvent(key))


def test_string_to_key():
    k = string_to_key("a")
    a = KeyEvent(key=KeyConst["a"])
    assert(k == a)

    k = string_to_key("ctrl+a")
    a = KeyEvent(key=KeyConst["a"], mods=Mods["ctrl"])
    assert(k == a)


def test_keybuffer_from_strings():
    kb1 = keybuffer_from_strings("ctrl+a", "shift+x")
    kb2 = KeyBuffer()
    kb2.append(KeyEvent(key=KeyConst["a"], mods=Mods["ctrl"]))
    kb2.append(KeyEvent(key=KeyConst["x"], mods=Mods["shift"]))
    assert(kb1.match(kb2) == KeyBuffer.exact_match)


