import pytest

from oasis.fileops import rm

# valid tests should return an empty string
# invalid tests should return a help string

def test_valid_simple(tmp_path):
    f = tmp_path / "a"
    f.touch()
    print(str(f))
    assert(not rm.go(("rm", str(f))))
    assert(not f.exists())


def test_valid_dir(tmp_path):
    d = tmp_path / "sub1"
    d.mkdir()
    print(str(d))
    assert(not rm.go(("rm", str(d))))
    assert(not d.exists())


def test_valid_recurse(tmp_path):
    d = tmp_path / "sub1"
    d.mkdir()
    f = d / "a"
    f.touch()
    assert(not rm.go(("rm", "-r", str(d))))
    assert(not f.exists() and not d.exists())

def test_invalid_args():
    assert(rm.go(("rm", )))

def test_invalid_simple(tmp_path):
    f = tmp_path / "a"
    assert(rm.go(("rm", str(f))))

def test_invalid_recurse(tmp_path):
    d = tmp_path / "sub1"
    d.mkdir()
    f = d / "a"
    f.touch()
    assert(rm.go(("rm", str(d))))
    assert(f.exists())


    
