from oasis.fileops import mv


def test_valid_file(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    assert(a.exists())
    assert(not b.exists())
    assert(not mv.go(("mv", str(a), str(b))))
    assert(not a.exists())
    assert(b.exists())


def test_valid_overwrite(tmp_path):
    a = tmp_path / "a"
    a.touch()
    a.write_text("hello")
    b = tmp_path / "b"
    b.touch()
    assert(b.read_text() == "")
    assert(not mv.go(("mv", "-f", str(a), str(b))))
    assert(not a.exists())
    assert(b.exists())
    assert(b.read_text() == "hello")


def test_invalid_overwrite(tmp_path):
    a = tmp_path / "a"
    a.touch()
    a.write_text("hello")
    b = tmp_path / "b"
    b.touch()
    assert(b.read_text() == "")
    assert(mv.go(("mv", str(a), str(b))))
    assert(a.exists())
    assert(b.exists())
    assert(b.read_text() == "")


def test_valid_manyfiles(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    b.touch()
    c = tmp_path / "c"
    c.mkdir()
    assert(not mv.go(("mv", str(a), str(b), str(c))))
    d = c / "a"
    e = c / "b"
    assert(not a.exists())
    assert(not b.exists())
    assert(d.exists())
    assert(e.exists())


def test_invalid_manyfiles(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    b.touch()
    c = tmp_path / "c"
    c.touch()
    assert(mv.go(("mv", str(a), str(b), str(c))))
