import logging

from oasis.core.modemachine import ModeMachine
from oasis.core.bindings import Bindings
from oasis.core.actions import Actions
from oasis.core.modemachine import Modes
from oasis.core.keyevent import keybuffer_from_strings as kb, string_to_key

def mock_bindings():
    bindings = Bindings()

    # some actions are specific to the widget
    Actions.append("Boom")
    Actions.append("yank_line", register="0")
    Actions.append("record_macro", register=None)
    Actions.append("yank_doc_end")
    Actions.append("find_char", char=None)
    Actions.add("command mode")
    Actions.add("navigate mode")

    # some actions are required
    bindings.add({
        kb("esc"):      Actions.abortkey,
        kb("y", "y"):   Actions.yank_line,
        kb("q"):        Actions.record_macro,
        kb("y", "G"):   Actions.yank_doc_end,
        kb("f"):        Actions.find_char,
        kb("a", "a", "a"): Actions.Boom,
        kb(":"):        Actions["command mode"],
        }, 
        Modes.navigate)
    bindings.add({
        kb("esc"):      Actions["navigate mode"],
        },
        Modes.command)
    bindings.add({
        kb("b"):        Actions.add("foobar"),
    },
    Modes.navigate, 
    123)
    return bindings


class MockTool():
    def __init__(self, ident):
        self.ident = ident
        self.handled = False

    def identity(self):
        return self.ident

    def handle(self, action):
        print(id(self), str(action))
        self.handled = True

def test1():
    logging.getLogger().setLevel(logging.DEBUG)
    mm = ModeMachine(mock_bindings())
    assert(mm.kp.mode == Modes.navigate)
    mm.handle_keyevent("global", string_to_key(":"))
    assert(mm.kp.mode == Modes.command)
    mm.handle_keyevent("global", string_to_key("esc"))
    assert(mm.kp.mode == Modes.navigate)

def test2():
    logging.getLogger().setLevel(logging.DEBUG)
    mm = ModeMachine(mock_bindings())
    tool1 = MockTool(123)
    tool2 = MockTool(123)
    mm.register_handler(Actions.foobar, tool1, tool1.handle)
    mm.register_handler(Actions.foobar, tool2, tool1.handle)
    
    assert(tool1.handled == False)
    assert(tool2.handled == False)
    mm.handle_keyevent(tool1, string_to_key("b"))
    assert(tool1.handled == True)
    assert(tool2.handled == False)

