import os
from oasis.fileops import ls


def test_valid(tmp_path):
    a = tmp_path / "a"
    a.touch()
    assert("a" in ls.go(("ls", str(tmp_path))))


def test_valid_long(tmp_path):
    a = tmp_path / "a"
    a.touch()
    assert("a" in ls.go(("ls", "-l", str(tmp_path))))


def test_invalid_path(tmp_path):
    a = tmp_path / "a"
    
    assert("such file" in ls.go(("ls", str(a))))


def test_cwd(tmp_path):
    result = ls.go(("ls", ))
    cur = os.listdir()
    for f in cur:
        assert(f in result)


