from oasis.core.keyevent import KeyEvent, KeyBuffer
from oasis.core.keyconst import KeyConst, Mods, KeyAliases


def test():
    ka = KeyEvent(KeyConst["a"])
    ka2 = KeyEvent(KeyConst["a"])
    kA = KeyEvent(KeyConst["a"], Mods["shift"])

    assert(ka == ka2)
    assert(kA != ka)

    d = {ka: "a", kA: "A"}
    assert(d[ka] == "a")
    assert(d[ka2] == "a")
    assert(d[kA] == "A")



def test_keyevent_hash():
    k1 = KeyEvent(KeyConst["escape"])
    k2 = KeyEvent(KeyConst["b"])

    assert(hash(k1) != hash(k2))

    check = {}
    for k in KeyConst.names():
        ke = KeyEvent(KeyConst[k])
        assert(not ke in check)
        check[ke] = True


def test_keybuffer_hash():
    check = {}
    for k in KeyConst.names():
        ke = KeyEvent(KeyConst[k])
        kb = KeyBuffer(ke)
        print(k)
        assert(not kb in check)
        check[kb] = True

