from oasis.fileops import grep


def test_valid(tmp_path):
    a = tmp_path / "a"
    a.write_text("hello world")
    assert(not grep.go(("grep", "a", str(a))))
    assert(grep.go(("grep", "hell", str(a))))


def test_invalid_re(tmp_path):
    a = tmp_path / "a"
    a.write_text("hello world a(")
    assert("pattern" in grep.go(("grep", "a(", str(a))))


def test_invalid_path(tmp_path):
    a = tmp_path / "a"
    assert("file" in grep.go(("grep", "a", str(a))))
