import pytest

from libs.ds import *

def test_bdict_dupe_values():
    with pytest.raises(Exception):
        d = BDict({"a": 0, "b":0})

def test_bdict_dupe_keys():
    d = BDict({"a": 0})
    d["a"] = 1
    assert(d["a"] == 1)
    assert(d[1] == "a")
    with pytest.raises(Exception):
        d[0]

def test_dict_reassign():
    d = BDict({"a":0, "b": 1})
    assert(len(d) == 2)
    d["a"] = 3
    assert(d["a"] == 3)
    with pytest.raises(Exception):
        d[0]
    d[1] = "c"
    with pytest.raises(Exception):
        d["b"]

    del d["a"]
    del d[1]
    assert(len(d) == 0)
    with pytest.raises(Exception):
        d[0]
    with pytest.raises(Exception):
        d[1]
    with pytest.raises(Exception):
        d["a"]
    with pytest.raises(Exception):
        d["b"]
    with pytest.raises(Exception):
        d["c"]


