from oasis.fileops import cp

def test_valid_file(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    assert(a.exists())
    assert(not b.exists())
    assert(not cp.go(("cp", str(a), str(b))))
    assert(a.exists())
    assert(b.exists())


def test_valid_overwrite(tmp_path):
    a = tmp_path / "a"
    a.touch()
    a.write_text("hello")
    b = tmp_path / "b"
    b.touch()
    assert(b.read_text() == "")
    assert(not cp.go(("cp", "-f", str(a), str(b))))
    assert(a.exists())
    assert(b.exists())
    assert(b.read_text() == "hello")


def test_invalid_overwrite(tmp_path):
    a = tmp_path / "a"
    a.touch()
    a.write_text("hello")
    b = tmp_path / "b"
    b.touch()
    assert(b.read_text() == "")
    assert(cp.go(("cp", str(a), str(b))))
    assert(a.exists())
    assert(b.exists())
    assert(b.read_text() == "")


def test_valid_manyfiles(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    b.touch()
    c = tmp_path / "c"
    c.mkdir()
    assert(not cp.go(("cp", str(a), str(b), str(c))))
    d = c / "a"
    e = c / "b"
    assert(d.exists())
    assert(e.exists())


def test_invalid_manyfiles(tmp_path):
    a = tmp_path / "a"
    a.touch()
    b = tmp_path / "b"
    b.touch()
    c = tmp_path / "c"
    c.touch()
    assert(cp.go(("cp", str(a), str(b), str(c))))
