from oasis.core.modemachine import Mode
from oasis.core.bindings import Bindings
from oasis.core.actions import Action
from oasis.core.keyevent import keybuffer_from_strings as kb, string_to_key



def test():
    mode = Mode("blah")
    bindings = Bindings()
    bindings.add({
        kb("b"): Action(name="Bob"),
        kb("esc"): Action(name="Alice"),
        kb("a", "a", "a"): Action(name="Boom"),
        }, 
        mode)

    result = bindings.match(kb("a", "a", "a"), mode)
    assert(result.name == "Boom")

    result = bindings.match(kb("b"), mode)
    assert(result.name == "Bob")

    result = bindings.match(kb("escape"), mode)
    assert(result.name == "Alice")

