""" A simple script to test Gui objects without loading the rest of the oasis """

from PySide2.QtWidgets import QApplication

import sys

from oasis.files import FilesGui
from oasis.inspecter import InspecterGui
from oasis.edit import EditGui


possible_args = {
    "files": FilesGui,
    "inspecter": InspecterGui,
    "edit": EditGui,
}

def show(module):
    app = QApplication([])
    gui = module()
    gui.show()
    app.exec_()


def showhelp():
    print("Possible args: %s" % ",".join(possible_args.keys()))


if __name__ == "__main__":
    try:
        arg = sys.argv[1]
    except:
        showhelp()
    else:
        if arg in possible_args:
            show(possible_args[arg])
        else:
            showhelp()
