""" This is just a tree data structure, nothing special
    I'm writing it to prove out the concepts I need for my tiling wm
"""


class Node():
    H = 0   # horizontal
    V = 1   # vertical
    #T = 2   # tabbed
    def __init__(self, parent=None, kind=H):
        self.lo = None
        self.parent = parent
        self.children = []
        self.kind = kind
        self.index = 0

    def change(self, kind):
        assert(kind in [Node.H, Node.V])
        self.kind = kind

    def select(self, i):
        self.index = i
        # search up through the tree and update index
        node = self.parent
        prev = self
        while node:
            i = node.children.index(prev)
            node.index = i
            prev = node
            node = node.parent

    def unselect(self):
        # search down through the tree and call unselect on all children?
        pass

    def cur_child(self):
        return self.children[self.index]

    def search(self, direction, kind):
        print("searching", direction, kind)
        assert(direction == 1 or direction == -1)
        assert(kind == Node.H or kind == Node.V)

        node_to_search = self
        while node_to_search:
            if node_to_search.kind != kind:
                print("searching parent")
                node_to_search = node_to_search.parent
            else:
                new_i = node_to_search.index + direction
                print("calc index", new_i)
                if new_i < 0 or new_i >= len(node_to_search):
                    node_to_search = node_to_search.parent
                else:
                    print("searching children")
                    while hasattr(node_to_search, "cur_child"):
                        child = node_to_search[new_i]
                        if not hasattr(child, "cur_child"):
                            # we are actually looking for the last Node in the tree
                            break
                        print("recursing")
                        # I don't want this here, because the unselect hasn't happened yet
                        # but you need to update index at every level...
                        # node_to_search.index = new_i
                        new_i = child.index
                        node_to_search = child
                    print("returning", new_i, child)
                    return new_i, node_to_search
        return None

    def insert(self, i, child):
        self.children.insert(i, child)
        self.index = i

    def remove(self, i):
        child = self.children.pop(i)
        if self.index >= len(self.children):
            self.index = len(self.children) - 1
        return child

    def __len__(self):
        return len(self.children)

    def __getitem__(self, key):
        return self.children[key]


class Tree():
    DIR_RIGHT = 0
    DIR_LEFT = 1
    DIR_UP = 2
    DIR_DOWN = 3
    DIRECTIONS = [DIR_RIGHT, DIR_LEFT, DIR_UP, DIR_DOWN]
    FORWARDBACK = {DIR_RIGHT: 1, DIR_LEFT: -1, DIR_UP: -1, DIR_DOWN: 1}
    ORIENTATION = {DIR_RIGHT: Node.H, DIR_LEFT: Node.H, DIR_UP: Node.V, DIR_DOWN: Node.V}

    def __init__(self, nodeclass=Node):
        self.root = None
        self.cur_node = None
        self.nodeclass = nodeclass

    def selected(self):
        return self.cur_node

    def change_selected(self, direction):
        assert(direction in Tree.DIRECTIONS)
        if self.cur_node is None:
            return
        result = self.cur_node.search(Tree.FORWARDBACK[direction], \
                Tree.ORIENTATION[direction])
        if result is None:
            return
        index, new_node = result
        self.cur_node.unselect()
        self.cur_node = new_node
        self.cur_node.select(index)

    def move_selected(self, direction):
        if self.cur_node is None:
            return
        result = self.cur_node.search(Tree.FORWARDBACK[direction], \
                Tree.ORIENTATION[direction])
        if result is None:
            return
        i, node = result
        self.cur_node.unselect()
        child = self.cur_node.remove(self.cur_node.index)
        node.insert(i, child)
        self.cur_node = node
        self.cur_node.select(i)

    def remove(self):
        if self.cur_node is None:
            return
        #TODO handle case where it needs to move to parent when cur_node is empty
        child = self.cur_node.remove(self.cur_node.index)
        if len(self.cur_node) == 0:
            self.cur_node = None
            self.root = None
        else:
            self.cur_node.select(self.cur_node.index)
        return child

    def insert(self, w, kind=None):
        if kind is None:
            if self.cur_node is None:
                kind = Node.H
            else:
                kind = self.cur_node.kind
        assert(kind in [Node.H, Node.V])
        if self.cur_node is None:
            self.cur_node = self.nodeclass(None, kind)
            self.cur_node.insert(0, w)
            self.cur_node.select(0)
            self.root = self.cur_node
            return
        if kind == self.cur_node.kind:
            i = self.cur_node.index + 1
            self.cur_node.insert(i, w)
            self.cur_node.select(i)
        else:
            i = self.cur_node.index
            child = self.cur_node.remove(i)
            new_node = self.nodeclass(self.cur_node, kind)
            new_node.insert(0, child)
            new_node.insert(1, w)
            self.cur_node.insert(i, new_node)
            new_node.select(1)
            self.cur_node = new_node

    def change_kind(self, kind):
        # this changes the arrangement of current nodes
        if self.cur_node is None:
            return
        self.cur_node.change(kind)

    def print_json(self):
        todo = [(0, self.root)]
        result = {}
        kinds = {Node.H: "H", Node.V: "V"}
        while len(todo) > 0:
            d, node = todo.pop()
            spacer = "-"*d
            if hasattr(node, "kind"):
                print(spacer+kinds[node.kind]+":")
                if len(node.children) > 0:
                    for c in reversed(node.children):
                        todo.append((d+1, c))
            else:
                print("%s%s" % (spacer, node))




if __name__ == "__main__":
    tree = Tree()
    # next split is tracked by GUI (switching from V/H)
    tree.insert("1", Node.H)
    tree.insert("2", Node.H)
    tree.insert("3", Node.V)
    tree.insert("4", Node.V)
    tree.change_selected(tree.DIR_LEFT)
    tree.change_selected(tree.DIR_LEFT)
    tree.insert("5")
    tree.print_json()
    tree.insert("6", Node.V)

    tree.change_selected(tree.DIR_UP)
    tree.remove()


    tree.print_json()
