from PySide2.QtWidgets import (
        QWidget,
        QTextEdit,
        QLabel,
        QVBoxLayout,
        QSizePolicy,
        )


class TerminalGui(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        self.lo = QVBoxLayout(self)
        self.lo.setContentsMargins(0, 0, 0, 0)
        self.lo.setSpacing(0)
        self.main = QTextEdit()
        self.main.append("\n"*100)  # so that subsequent lines are added at the bottom
        self.status = QLabel()
        self.status.setSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        self.status.setText("Waiting...")

        self.lo.addWidget(self.main)
        self.lo.addWidget(self.status)
