""" Inspector gui - A Debugging tool"""
#from oasis.core.basewidget import BaseWidget

from PySide2.QtWidgets import QWidget, QVBoxLayout, QTextEdit
from PySide2.QtCore import Qt, QTimer


flashStyle  = \
'''QWidget {
    border-color: red;
    border-width: 4;
}'''

class InspecterGui(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        self.lo = QVBoxLayout(self)
        self.lo.setContentsMargins(0, 0, 0, 0)
        self.lo.setSpacing(0)
        self.output = QTextEdit()
        self.output.setReadOnly(True)
        self.output.setFocusPolicy(Qt.NoFocus)
        self.output.append("Hello World\n")
        self.lo.addWidget(self.output)

    def report(self, text):
        self.output.setText(text)

    def flash(self):
        self.ss = self.styleSheet()
        self.setStyleSheet(flashStyle)
        QTimer.singleShot(1000, self.unflash)

    def unflash(self):
        self.setStyleSheet(self.ss)

