""" Inspecter - A Debugging tool """

import logging

from oasis.core.abstracttool import AbstractTool
from oasis.core.commandparser import Command
from oasis.core.actions import Actions

class InspecterTool(AbstractTool):
    def __init__(self, model):
        AbstractTool.__init__(self, model)
        self.action_handlers = {
            Actions.add("test action"): self.flash,
            Actions.add("save quit tool"): self.save,
        }
        self.commands = [
            Command("loglevel", self.setLevel, ["level"]),
            Command("debug", self.debugReport, ["report"]),
        ]

        self.reports = {
            "bindings": self.bindingReport,
            "actions": self.actionReport,
        }

    ## Command Handlers
    def setLevel(self, args):
        if not "level" in args or not args["level"] in ["error", "debug"]:
            logging.error("You can only set log levels to error or debug")
            # TODO: feedback to user (besides logging)
            return
        if args["level"] == "debug":
            logging.getLogger().setLevel(logging.DEBUG)
        elif args["level"] == "error":
            logging.getLogger().setLevel(logging.ERROR)

    def debugReport(self, args):
        if not "report" in args or not args["report"] in self.reports:
            msg = "The only valid debug report is: %s" % ",".join(self.reports.keys())
            logging.error(msg)
            # TODO: user feedback
            return
        self.reports[args["report"]]()

    ## Reports
    def bindingReport(self):
        self.gui.report(str(self.model.config.bindings))

    def actionReport(self):
        result = ""
        handlers = self.model.modemachine.action_handlers
        for obj in handlers:
            result += "%s:\n" % obj
            for k,v in handlers[obj].items():
                result += "  %s=%s\n" % (k,v)
        self.gui.report(result)

    ## Action Handlers
    def flash(self, args):
        self.gui.flash()

    def save(self, action):
        logging.debug("Inspecter saved!")




