from PySide2.QtWidgets import QApplication, QWidget, QVBoxLayout, \
        QTableWidget, QTableWidgetItem, \
        QLabel

from oasis.files.const import *

from libs.classutil import requiresNotNone, requiresCallable


class MyTable(QTableWidget):
    def __init__(self):
        QTableWidget.__init__(self)
        self.handler = None

    def setHandler(self, func):
        self.handler = func

    def keyPressEvent(self, event):
        key = event.key()
        requiresCallable(self, "handler")
        return self.handler(event)


class FilesGui(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        self.lo = QVBoxLayout(self)
        self.lo.setContentsMargins(0, 0, 0, 0)
        self.lo.setSpacing(0)
        self.label = QLabel()
        self.table = MyTable()
        self.table.setHandler(self.keyHandler)

        self.table.setHorizontalHeaderLabels(COLUMNS)

        self.lo.addWidget(self.label)
        self.lo.addWidget(self.table)

    def keyHandler(self, event):
        requiresCallable(self, "handler")
        return self.handler(event, self)

    def setHandler(self, handler):
        self.handler = handler

    def setRowData(self, rowindex, data):
        for column, field in enumerate(data):
            item = self.table.item(rowindex, column)
            if item is None:
                item = QTableWidgetItem()
                self.table.setItem(rowindex, column, item)
            item.setText(field)

    ### Public API
    def setStatus(self, message):
        self.label.setText(message)

    def populateTable(self, data):
        self.setRowCount(len(data))
        for i, row in enumerate(data):
            self.setRowData(i, row)

    def showLongView(self):
        self.table.setColumnHidden(ColumnIndexes.MODE, False)
        self.table.setColumnHidden(ColumnIndexes.USER, False)
        self.table.setColumnHidden(ColumnIndexes.GROUP, False)
        self.table.setColumnHidden(ColumnIndexes.SIZE, False)
        self.table.setColumnHidden(ColumnIndexes.DATE, False)

    def showShortView(self):
        self.table.setColumnHidden(ColumnIndexes.MODE, True)
        self.table.setColumnHidden(ColumnIndexes.USER, True)
        self.table.setColumnHidden(ColumnIndexes.GROUP, True)
        self.table.setColumnHidden(ColumnIndexes.SIZE, True)
        self.table.setColumnHidden(ColumnIndexes.DATE, True)

    def currentFilename(self):
        pass




