""" 
    touch.py - Not a true implementation of GNU touch. touch.py's only function
    is to create files.
"""

from libs.arglib import ArgParser, exceptReturnsHelp

parser = ArgParser("touch", (
    ("path", {"help": "file(s) to create", "nargs": "+", "type": str, "default": ""}),
    ))


@exceptReturnsHelp(parser)
def go(args):
    """
        touch.go(args): pass in sys.argv
        creates all files in args
        returns errors as a string
    """
    results = ""
    for fn in args.path:
        try:
            fo = open(fn, "w")
            fo.close()
        except Exception as e:
            results += str(e)

    return results


