import os
import shutil

from libs.arglib import ArgParser, exceptReturnsHelp

parser = ArgParser("rm", 
        (("-r", {"help": "Recursive remove", "action": "store_true"}),
        ("path", {"help": "file(s) to remove", "nargs": "+", "type": str, "default": ""})
    ))


@exceptReturnsHelp(parser)
def go(args):
    """
        rm.go(args): pass in sys.argv
        removes files
        args.path: files to remove
        args.r: recursive flag
    """
    results = ""
    for path in args.path:
        if not args.r:
            if os.path.isdir(path):
                func = os.rmdir
            else:
                func = os.remove
        else:
            func = shutil.rmtree

        try:
            func(path)
        except Exception as e:
            results += str(e) + "\n"
    return results




