import os
import shutil
from libs.arglib import ArgParser, exceptReturnsHelp

parser = ArgParser("mv", (
    ("-f", {"help": "Do not prompt before overwriting", "action": "store_true"}),
    ("path", {"help": "file(s) to move", "nargs": "+", "type": str, "default": ""}),
    ("destination", {"help": "file or folder to move to"})
))


@exceptReturnsHelp(parser)
def go(args):
    if len(args.path) > 1 and not os.path.isdir(args.destination):
        return "When moving multiple files the destination must be an existing folder"

    results = ""
    for fn in args.path:
        if os.path.isdir(args.destination):
            shutil.move(fn, args.destination)
        elif os.path.isfile(args.destination):
            if args.f:
                shutil.move(fn, args.destination)
            else:
                results += "%s already exists. Use -f to overwrite.\n" % args.destination
        else:
            shutil.move(fn, args.destination)
    return results

