import os
from datetime import datetime

from libs.humanize import humanize
from libs.arglib import ArgParser, exceptReturnsHelp


parser = ArgParser("ls", (
    ("-l", {"help": "detailed (long) listing", "action": "store_true"}),
    ("path", {"help": "list files at this path",  "nargs": "?", 
        "type": str, "default": ""}),
))


@exceptReturnsHelp(parser)
def go(args):
    if args.path is None or args.path == "":
        cwd = os.getcwd()
    else:
        cwd = args.path

    try:
        files = os.listdir(cwd)
    except Exception as e:
        return str(e)

    results = ""
    for f in files:
        if args.l:
            s = os.lstat(os.path.join(cwd, f))
            size = humanize(s.st_size)
            user = s.st_uid
            date = datetime.fromtimestamp(s.st_mtime).strftime("%Y%m%d %H%M")
            results += "\t".join(map(str, 
                [s.st_mode, user, s.st_gid, size, date, f])) \
                + "\n"
        else:
            results += f + "\n"
    return results


