import os
import re

from libs.arglib import ArgParser, exceptReturnsHelp


parser = ArgParser("grep", (
    ("exp", {"help": "expression to search for (regex supported)", "type":str}),
    ("path", {"help": "file(s) to search",  "nargs": "+", 
        "type": str, "default": ""}),
))


@exceptReturnsHelp(parser)
def go(args):
    try:
        rexp = re.compile(args.exp)
    except Exception as e:
        return str(e)

    results = ""
    # TODO: surely there is a faster way
    for fn in args.path:
        try:
            fo = open(fn, "r")
        except:
            results += fn + ": invalid filename" + "\n"
            continue
        for line in fo:
            if rexp.search(line):
                results += fn + ": " + line + "\n"
    return results

