import os
import shutil

from libs.arglib import ArgParser, exceptReturnsHelp


parser = ArgParser("cp", (
    ("-f", {"help": "overwrite existing", "action": "store_true"}),
    ("source", {"help": "file to copy",  "nargs": "+", 
        "type": str, "default": ""}),
    ("destination", {"help": "destination to copy the file(s) to"})
))

@exceptReturnsHelp(parser)
def go(args):

    if len(args.source) > 1 and not os.path.isdir(args.destination):
        return "When copying multiple files the destination must be an existing folder"

    for fn in args.source:
        if os.path.exists(args.destination):
            if os.path.isdir(args.destination):
                dest = os.path.join(args.destination, 
                        os.path.split(fn)[1])
                shutil.copy(fn, dest)
            elif args.f:
                os.remove(args.destination)
                shutil.copy(fn, args.destination)
            else:
                return "%s exists. Use -f to overwrite." % args.destination
        else:
            shutil.copy(fn, args.destination)

    return ""

