import os

from libs.arglib import ArgParser, exceptReturnsHelp

parser = ArgParser("cd", (
    ("path", {"help": "change the current working directory",  "nargs": "?", 
        "type": str, "default": ""}),
))


@exceptReturnsHelp(parser)
def go(args):
    if not args.path:
        return os.getcwd() + "\n"

    try:
        os.chdir(args.path)
    except Exception as e:
        return str(e)

    return ""

    
