from oasis.inspecter import InspecterTool, InspecterGui
from oasis.wm import WmTool, WmGui
from oasis.edit import EditTool, EditGui
from oasis.files import FilesTool, FilesGui
from oasis.web import WebTool, WebGui
from oasis.term import TerminalTool, TerminalGui
from oasis.table import TableTool, TableGui

"""
Not implemented yet
from oasis.table.ctrl import Ctrl as Table
from oasis.web.ctrl import Ctrl as Web
"""

class ToolFactory():
    def __init__(self, name, ctrl, gui):
        self.name = name
        # classes
        self.ctrl = ctrl
        self.gui = gui

    def spawn(self, model, keypresshandler, actionregister, addcommand, skipgui=False):
        ctrl = self.ctrl(model)
        ctrl.factory = self
        if not skipgui:
            gui = self.gui()
            ctrl.attach(gui)
            ctrl.setHandler(keypresshandler)
        ctrl.registerActionHandlers(actionregister)
        ctrl.registerCommands(addcommand)
        return ctrl

    def ctrlHasMethod(self, methodname):
        return hasattr(self.ctrl, methodname)

    def identity(self):
        return self.name

    def __str__(self):
        return "%s (%s)" % (self.name, id(self))



class _ToolClassRegistry():
    mapping = {
        "wm": ToolFactory("wm", WmTool, WmGui),
        "inspecter": ToolFactory("inspecter", InspecterTool, InspecterGui),
        "edit": ToolFactory("edit", EditTool, EditGui),
        "files": ToolFactory("files", FilesTool, FilesGui),
        "web": ToolFactory("web", WebTool, WebGui),
        "terminal": ToolFactory("terminal", TerminalTool, TerminalGui),
        "table": ToolFactory("table", TableTool, TableGui),
    }

    def __contains__(self, name):
        return name in _ToolClassRegistry.mapping

    def __getitem__(self, name):
        return getattr(self, name)

    def __getattr__(self, name):
        if name in _ToolClassRegistry.mapping:
            return _ToolClassRegistry.mapping[name]
        else:
            raise AttributeError("Undefined widget in oasis.core.widgets: %s" % name)

ToolClassRegistry = _ToolClassRegistry()
