""" Translate Qt.KeyEvents to oasis.core.keyevent.KeyEvents """

from oasis.core.keyconst import KeyConst, Mods
from oasis.core.keyevent import KeyEvent
from PySide2.QtCore import Qt


QT_TO_OASIS_KEYS = {
    Qt.Key_A: KeyConst["a"],
    Qt.Key_B: KeyConst["b"],
    Qt.Key_C: KeyConst["c"],
    Qt.Key_D: KeyConst["d"],
    Qt.Key_E: KeyConst["e"],
    Qt.Key_F: KeyConst["f"],
    Qt.Key_G: KeyConst["g"],
    Qt.Key_H: KeyConst["h"],
    Qt.Key_I: KeyConst["i"],
    Qt.Key_J: KeyConst["j"],
    Qt.Key_K: KeyConst["k"],
    Qt.Key_L: KeyConst["l"],
    Qt.Key_M: KeyConst["m"],
    Qt.Key_N: KeyConst["n"],
    Qt.Key_O: KeyConst["o"],
    Qt.Key_P: KeyConst["p"],
    Qt.Key_Q: KeyConst["q"],
    Qt.Key_R: KeyConst["r"],
    Qt.Key_S: KeyConst["s"],
    Qt.Key_T: KeyConst["t"],
    Qt.Key_U: KeyConst["u"],
    Qt.Key_V: KeyConst["v"],
    Qt.Key_W: KeyConst["w"],
    Qt.Key_X: KeyConst["x"],
    Qt.Key_Y: KeyConst["y"],
    Qt.Key_Z: KeyConst["z"],
    Qt.Key_1: KeyConst["1"],
    Qt.Key_2: KeyConst["2"],
    Qt.Key_3: KeyConst["3"],
    Qt.Key_4: KeyConst["4"],
    Qt.Key_5: KeyConst["5"],
    Qt.Key_6: KeyConst["6"],
    Qt.Key_7: KeyConst["7"],
    Qt.Key_8: KeyConst["8"],
    Qt.Key_9: KeyConst["9"],
    Qt.Key_0: KeyConst["0"],
    Qt.Key_Minus: KeyConst["minus"],
    Qt.Key_Plus: KeyConst["plus"],
    Qt.Key_Underscore: KeyConst["underscore"],
    Qt.Key_Equal: KeyConst["equal"],
    Qt.Key_AsciiTilde: KeyConst["tilde"],
    Qt.Key_QuoteLeft: KeyConst["accent"],
    Qt.Key_Exclam: KeyConst["exclamation"],
    Qt.Key_At: KeyConst["at"],
    Qt.Key_NumberSign: KeyConst["pound"],
    Qt.Key_Dollar: KeyConst["dollar"],
    Qt.Key_Percent: KeyConst["percent"],
    Qt.Key_AsciiCircum: KeyConst["caret"],
    Qt.Key_Ampersand: KeyConst["ampersand"],
    Qt.Key_Asterisk: KeyConst["asterisk"],
    Qt.Key_ParenLeft: KeyConst["lparenthesis"],
    Qt.Key_ParenRight: KeyConst["rparenthesis"],
    Qt.Key_Tab: KeyConst["tab"],
    Qt.Key_BraceLeft: KeyConst["lcurly"],
    Qt.Key_BraceRight: KeyConst["rcurly"],
    Qt.Key_BracketLeft: KeyConst["lsquare"],
    Qt.Key_BracketRight: KeyConst["rsquare"],
    Qt.Key_Bar: KeyConst["pipe"],
    Qt.Key_Backslash: KeyConst["backslash"],
    Qt.Key_Colon: KeyConst["colon"],
    Qt.Key_Semicolon: KeyConst["semicolon"],
    Qt.Key_QuoteDbl: KeyConst["dquote"],
    Qt.Key_Apostrophe: KeyConst["squote"],
    Qt.Key_Greater: KeyConst["greater"],
    Qt.Key_Less: KeyConst["less"],
    Qt.Key_Comma: KeyConst["comma"],
    Qt.Key_Period: KeyConst["period"],
    Qt.Key_Question: KeyConst["question"],
    Qt.Key_Slash: KeyConst["slash"],
    Qt.Key_Space: KeyConst["space"],
    Qt.Key_Enter: KeyConst["enter"],
    Qt.Key_Return: KeyConst["return"],
    Qt.Key_Insert: KeyConst["insert"],
    Qt.Key_Home: KeyConst["home"],
    Qt.Key_PageUp: KeyConst["pageup"],
    Qt.Key_PageDown: KeyConst["pagedown"],
    Qt.Key_Delete: KeyConst["delete"],
    Qt.Key_End: KeyConst["end"],
    Qt.Key_Escape: KeyConst["escape"],
    Qt.Key_F1: KeyConst["f1"],
    Qt.Key_F2: KeyConst["f2"],
    Qt.Key_F3: KeyConst["f3"],
    Qt.Key_F4: KeyConst["f4"],
    Qt.Key_F5: KeyConst["f5"],
    Qt.Key_F6: KeyConst["f6"],
    Qt.Key_F7: KeyConst["f7"],
    Qt.Key_F8: KeyConst["f8"],
    Qt.Key_F9: KeyConst["f9"],
    Qt.Key_F10: KeyConst["f10"],
    Qt.Key_F11: KeyConst["f11"],
    Qt.Key_F12: KeyConst["f12"],
    Qt.Key_Print: KeyConst["print"],
    Qt.Key_Pause: KeyConst["pause"],
    Qt.Key_Left: KeyConst["left"],
    Qt.Key_Right: KeyConst["right"],
    Qt.Key_Up: KeyConst["up"],
    Qt.Key_Down: KeyConst["down"],
    Qt.Key_Backspace: KeyConst["backspace"],
    Qt.Key_Backtab: KeyConst["backtab"],
    Qt.Key_Shift: KeyConst["shift"],
    Qt.Key_Control: KeyConst["control"],
    Qt.Key_Alt: KeyConst["alt"],
    Qt.Key_Meta: KeyConst["meta"],
}


QT_TO_OASIS_MODS = {
    Qt.ShiftModifier: Mods["shift"],
    Qt.ControlModifier: Mods["ctrl"],
    Qt.AltModifier: Mods["alt"],
    Qt.MetaModifier: Mods["meta"],
}

def convert_mods(mods):
    return sum([
        QT_TO_OASIS_MODS[m] 
        for m in QT_TO_OASIS_MODS.keys()
        if mods & m
        ])

def qtTrans(qkeyevent):
    return KeyEvent(
        key  = QT_TO_OASIS_KEYS[qkeyevent.key()],
        mods = convert_mods(qkeyevent.modifiers()),
        ev   = qkeyevent
    )

