from libs.ds import BDict


class ConstDict(BDict):
    """ 
    """
    def __init__(self, d):
        BDict.__init__(self, d)
        self._d = d

    def names(self):
        return list(self._d.keys())

    def values(self):
        return list(self._d.values())


Mods = ConstDict({
    "shift": 0x100,
    "ctrl": 0x200,
    "alt": 0x400,
    "meta": 0x800,
})


KeyConst = ConstDict({
    "a": 1,
    "b": 2,
    "c": 3,
    "d": 4,
    "e": 5,
    "f": 6,
    "g": 7,
    "h": 8,
    "i": 9,
    "j": 10,
    "k": 11,
    "l": 12,
    "m": 13,
    "n": 14,
    "o": 15,
    "p": 16,
    "q": 17,
    "r": 18,
    "s": 19,
    "t": 20,
    "u": 21,
    "v": 22,
    "w": 23,
    "x": 24,
    "y": 25,
    "z": 26,
    "1": 27,
    "2": 28,
    "3": 29,
    "4": 30,
    "5": 31,
    "6": 32,
    "7": 33,
    "8": 34,
    "9": 35,
    "0": 36,
    "minus": 37,
    "plus": 38,
    "underscore": 39,
    "equal": 40,
    "tilde": 42,
    "accent": 43,
    "exclamation": 44,
    "at": 45,
    "pound": 46,
    "dollar": 47,
    "percent": 48,
    "caret": 49,
    "ampersand": 50,
    "asterisk": 51,
    "lparenthesis": 52,
    "rparenthesis": 53,
    "tab": 54,
    "lcurly": 55,
    "rcurly": 56,
    "lsquare": 57,
    "rsquare": 58,
    "pipe": 59,
    "backslash": 60,
    "colon": 61,
    "semicolon": 62,
    "dquote": 63,
    "squote": 64,
    "greater": 65,
    "less": 66,
    "comma": 67,
    "period": 68,
    "question": 69,
    "slash": 70,
    "space": 99,
    "enter": 100,
    "return": 101,
    "insert": 102,
    "home": 103,
    "pageup": 104,
    "pagedown": 105,
    "delete": 106,
    "end": 107,
    "escape": 108,
    "f1": 109,
    "f2": 110,
    "f3": 111,
    "f4": 112,
    "f5": 113,
    "f6": 114,
    "f7": 115,
    "f8": 116,
    "f9": 117,
    "f10": 118,
    "f11": 119,
    "f12": 120,
    "print": 121,
    "pause": 122,
    "left": 123,
    "right": 124,
    "up": 125,
    "down": 126,
    "backspace": 127,
    "backtab": 128,
    "shift": 129,
    "control": 130,
    "alt": 131,
    "meta": 132,
})


# useful for dealing with user config files
KeyAliases = {
    "-": "minus",
    "+": "plus",
    "_": "underscore",
    "=": "equal",
    "bksp": "backspace",
    "~": "tilde",
    "`": "accent",
    "!": "exclamation",
    "@": "at",
    "#": "pound",
    "$": "dollar",
    "%": "percent",
    "^": "caret",
    "&": "ampersand",
    "*": "asterisk",
    "(": "lparenthesis",
    ")": "rparenthesis",
    "{": "lcurly",
    "}": "rcurly",
    "[": "lsquare",
    "]": "rsquare",
    "|": "pipe",
    "\\": "backslash",
    ":": "colon",
    ";": "semicolon",
    '"': "dquote",
    "'": "squote",
    ">": "greater",
    "<": "less",
    ",": "comma",
    ".": "period",
    "?": "question",
    "/": "slash",
    " ": "space",
    "del": "delete",
    "esc": "escape",
}

ImpliedMods = {
    "colon": Mods["shift"],
    "dquote": Mods["shift"],
    "greater": Mods["shift"],
    "less": Mods["shift"],
    "question": Mods["shift"],
    "lcurly": Mods["shift"],
    "rcurly": Mods["shift"],
    "pipe": Mods["shift"],
    "tilde": Mods["shift"],
    "exclamation": Mods["shift"],
    "at": Mods["shift"],
    "pound": Mods["shift"],
    "dollar": Mods["shift"],
    "percent": Mods["shift"],
    "caret": Mods["shift"],
    "ampersand": Mods["shift"],
    "asterisk": Mods["shift"],
    "lparenthesis": Mods["shift"],
    "rparenthesis": Mods["shift"],
    "plus": Mods["shift"],
    "underscore": Mods["shift"],
}
