""" A base widget class based on QWidget """
import logging

from libs.classutil import requiresNotNone, requiresCallable
from oasis.core.qttrans import qtTrans


def validateGui(self):
    # validates that correct links have been made
    logging.debug("%s: %s" % (self, "shown"))
    requiresNotNone(self, "ctrl")
    requiresCallable(self, "keyPressHandler")


def keyPressHandlerForApp(self, event):
    return self.keyPressHandler(qtTrans(event), self.ctrl)


def keyPressHandlerForContainer(self, event):
    return self.parent().keyPressEvent(event)


def keyPressHandlerForEndPoint(cls, self, event):
    if not self.parent().keyPressEvent(event):
        return cls.keyPressEvent(self, event)
