import logging


class Bindings():
    def __init__(self):
        # map of keybuffers to Actions
        self.bindings = {}

    def subset(self, *args):
        """ Returns a subset of bindings with matching *args
        """
        result = []
        for k,v in self.bindings.items():
            if v in args:
                result.append(k)
        return result

    def match(self, key, mode, toolId=None):
        if toolId is None:
            toolId = "global"
        assert(mode in self.bindings)
        assert(toolId in self.bindings[mode])
        #assert(key in self.bindings[mode][toolId])
        if key in self.bindings[mode][toolId]:
            return self.bindings[mode][toolId][key]
        else:
            return None

    def get_all(self, mode, toolId=None):
        if toolId is None:
            toolId = "global"
        if toolId in self.bindings[mode]:
            return self.bindings[mode][toolId].items()
        else:
            return []

    def add(self, bindings, mode, toolId=None):
        """ Add *bindings* to the global bindings object
            Mode: the mode in which these bindings apply
            Widget: is the toolId that added the bindings,
            ModeManager will pass actions back to this toolId
            if it's current. Widget=none, means these are global
            bindings. Use a hashable toolIdid. id() probly works.
        """
        if not mode in self.bindings:
            self.bindings[mode] = {}

        if toolId is None:
            toolId = "global"

        if not toolId in self.bindings[mode]:
            self.bindings[mode][toolId] = {}

        for k,v in bindings.items():
            if not k in self.bindings[mode][toolId]:
                self.bindings[mode][toolId][k] = v
            else:
                logging.error("Duplicate binding {} for tool {}".format(k,v))

    def __str__(self):
        b = {}
        for mode in self.bindings:
            for toolId in self.bindings[mode]:
                if not str(toolId) in b:
                    b[str(toolId)] = {}
                b[str(toolId)][str(mode)] = []
                for k,v in self.bindings[mode][toolId].items():
                    b[str(toolId)][str(mode)].append("%s=%s" % (k,v))
        result = ""
        for toolId in b:
            result += "%s: \n" % toolId
            for mode in b[toolId]:
                result += "  %s:\n    " % mode
                result += "\n    ".join(b[toolId][mode]) + "\n"
        return result 
