class Action():
    def __init__(self, name, **kwargs):
        self.name = name
        self.defaults = kwargs
        self.args = {}
        # flags that alter action behavior
        # these are things you can prefix the command with
        """
        Action Extensions:
        self.accept_prefix_int = False
        self.accept_prefix_register = False
        # these come after the command and are required
        self.require_suffix_register = False
        self.require_suffix_move = False
        self.require_suffix_char = False

    def setargs(self, **kwargs):
        self.args = kwargs

    def getarg(self, name):
        if name in self.args:
            return self.args[name]
        elif name in self.defaults:
            return self.defaults[name]
        return None
    """
    
    def copy(self):
        # return a deep copy of self
        a = Action(self.name)
        a.args = dict(self.args)
        return a

    def __str__(self):
        return self.name

    def __eq__(self, other):
        if not hasattr(other, "name"):
            return False
        return self.name == other.name

    def __hash__(self):
        return id(self)


class ActionsConst():
    def __init__(self):
        self.actions = {}
        self.add("enter_command_mode")
        self.add("process_command")
        self.add("abortkey")
        self.add("enter_navigate")
        self.add("move_cursor_left")
        self.add("move_cursor_right")

    def add(self, name, **kwargs):
        if not name in self.actions:
            if kwargs is None:
                self.actions[name] = Action(name)
            else:
                self.actions[name] = Action(name, **kwargs)
        return self.actions[name]

    def append(self, name, **kwargs):
        self.add(name, **kwargs)

    def __contains__(self, key):
        return key in self.actions

    def __getitem__(self, key):
        return getattr(self, key)

    def __getattr__(self, name):
        if name in self.actions:
            return self.actions[name]
        else:
            raise AttributeError("Unknown action: %s" % name)

Actions = ActionsConst()
