from libs.classutil import requiresNotNone

class AbstractTool():
    def __init__(self, model):
        """
            model: a link to the application model object
            identity: An abstract key to identify the kind of tool (ex. edit)
                see oasis/core/toolclasses.py
            action_handlers: (action: function) registerActionHandlers will be
                called by ToolFactory
            commands: a list of Command objects. registerCommands will be called
                by ToolFactory
        """
        self.model = model
        self.factory = None

        # override these in sub class
        self.action_handlers = {}
        self.commands = []

    def identity(self):
        return self.factory.identity()

    # Do not override these methods #
    def attach(self, gui):
        """ 
        attaches this controller to a gui object
        """
        self.gui = gui
        gui.ctrl = self

    def setHandler(self, handler):
        """ 
        sets the keyPressHandler attribute in the gui
        handler: function that handles keyevents 
        """
        requiresNotNone(self, "gui")
        self.gui.keyPressHandler = handler
    
    def registerActionHandlers(self, registerHandlerFunc):
        """
        register this tool's ActionHandlers with the dispatching object
        (should be ModeMachine)
        """
        for action, func in self.action_handlers.items():
            registerHandlerFunc(action, self, func)

    def registerCommands(self, addCommandFunc):
        """
            registers the commands this tool accepts with CommandParser
        """
        for c in self.commands:
            addCommandFunc(self, c)
