prefixes = ["T", "G", "M", "K"]
divisors = [10**12, 10**9, 10**6, 10**3]
procs = zip(prefixes, divisors)

def humanize(size):
    # takes an integer size and turns it into a human readable format
    for p, d in procs:
        if size > d:
            return "%d%s" % (size / d, p)
    return str(size)


