class BDict():
    def __init__(self, d=None):
        self.d = {}
        if d is not None:
            self.populate(d)

    def populate(self, d):
        for k, v in d.items():
            assert(not v in self)
            self[k] = v

    def keys(self):
        return self.d.keys()

    def __len__(self):
        return int(len(self.d) / 2)

    def __getitem__(self, k):
        if k in self.d:
            return self.d[k]
        else:
            raise KeyError("key: %s not in Bdict" % k)
        return None

    def __setitem__(self, k, v):
        if k in self:
            del self[k]
        if v in self:
            del self[v]
        self.d[k] = v
        self.d[v] = k

    def __delitem__(self, k):
        v = self[k]
        del self.d[k]
        del self.d[v]

    def __contains__(self, item):
        return item in self.d

    def __iter__(self):
        return self.d.__iter__()



